/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CustomRecipeFactory
implements IFactory<FactoryVoidInput, CustomRecipe> {
    private static final String CUSTOM_RECIPE_ID_PROP = "id";

    @Override
    @NotNull
    public CustomRecipe getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
        if (context.length != 8 && context.length != 13) {
            throw new IllegalArgumentException("Unsupported context - Not correct number of parameters. Only 8 or 13are allowed!");
        }
        if (!(context[0] instanceof String)) {
            throw new IllegalArgumentException("Unsupported context - Invalid Crafter Recipe crafter");
        }
        if (!(context[5] instanceof ResourceLocation && context[6] instanceof ResourceLocation && context[7] instanceof ResourceLocation)) {
            throw new IllegalArgumentException("Unsupported context - Invalid ResourceLocation");
        }
        if (!(context[8] instanceof ResourceLocation)) {
            throw new IllegalArgumentException("Unsupported context - Invalid ResourceLocation");
        }
        if (!(context[9] instanceof List && context[11] instanceof List && context[12] instanceof List)) {
            throw new IllegalArgumentException("Unsupported context - Invalid Item Information");
        }
        return this.getNewInstance((String)context[0], (Integer)context[1], (Integer)context[2], (Boolean)context[3], (Boolean)context[4], (ResourceLocation)context[5], (ResourceLocation)context[6], (ResourceLocation)context[7], (ResourceLocation)context[8], (List)context[9], (ItemStack)context[10], (List)context[11], (List)context[12], (Block)context[13]);
    }

    private CustomRecipe getNewInstance(String crafter, int minBldgLevel, int maxBldgLevel, boolean mustExist, boolean showTooltip, ResourceLocation recipeId, ResourceLocation researchReq, ResourceLocation researchExclude, ResourceLocation lootTable, List<ItemStorage> inputs, ItemStack primaryOutput, List<ItemStack> secondaryOutput, List<ItemStack> altOutputs, Block intermediate) {
        return new CustomRecipe(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    @NotNull
    public TypeToken<CustomRecipe> getFactoryOutputType() {
        return TypeToken.of(CustomRecipe.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull CustomRecipe recipe) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("crafter", recipe.getCrafter());
        compound.func_74778_a(CUSTOM_RECIPE_ID_PROP, recipe.getRecipeStorage().getRecipeSource().toString());
        if (recipe.getRequiredResearchId() != null) {
            compound.func_74778_a("research-id", recipe.getRequiredResearchId().toString());
        }
        if (recipe.getExcludedResearchId() != null) {
            compound.func_74778_a("not-research-id", recipe.getExcludedResearchId().toString());
        }
        if (recipe.getLootTable() != null) {
            compound.func_74778_a("loot-table", recipe.getLootTable().toString());
        }
        compound.func_74768_a("min-building-level", recipe.getMinBuildingLevel());
        compound.func_74768_a("max-building-level", recipe.getMaxBuildingLevel());
        compound.func_74757_a("must-exist", recipe.getMustExist());
        compound.func_74757_a("show-tooltip", recipe.getShowTooltip());
        ListNBT inputs = new ListNBT();
        for (ItemStorage in : recipe.getInputs()) {
            inputs.add((Object)controller.serialize(in));
        }
        compound.func_218657_a("inputs", (INBT)inputs);
        compound.func_218657_a("result", (INBT)recipe.getPrimaryOutput().func_77955_b(new CompoundNBT()));
        if (recipe.getSecondaryOutput().size() > 0) {
            ListNBT secondaryOutputs = new ListNBT();
            for (ItemStack is : recipe.getSecondaryOutput()) {
                secondaryOutputs.add((Object)is.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("additional-output", (INBT)secondaryOutputs);
        }
        if (recipe.getAltOutputs().size() > 0) {
            ListNBT altOutputs = new ListNBT();
            for (ItemStack is : recipe.getAltOutputs()) {
                altOutputs.add((Object)is.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("alternate-output", (INBT)altOutputs);
        }
        compound.func_74778_a("intermediate", recipe.getIntermediate().getRegistryName().toString());
        return compound;
    }

    @Override
    @NotNull
    public CustomRecipe deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        String crafter = nbt.func_74779_i("crafter");
        ResourceLocation recipeId = nbt.func_186855_b(CUSTOM_RECIPE_ID_PROP) ? new ResourceLocation(nbt.func_74779_i(CUSTOM_RECIPE_ID_PROP)) : null;
        ResourceLocation researchReq = nbt.func_186855_b("research-id") ? new ResourceLocation(nbt.func_74779_i("research-id")) : null;
        ResourceLocation researchExclude = nbt.func_186855_b("not-research-id") ? new ResourceLocation(nbt.func_74779_i("not-research-id")) : null;
        ResourceLocation lootTable = nbt.func_186855_b("loot-table") ? new ResourceLocation(nbt.func_150285_a_()) : null;
        int minBldgLevel = nbt.func_74762_e("min-building-level");
        int maxBldgLevel = nbt.func_74762_e("max-building-level");
        boolean mustExist = nbt.func_74767_n("must-exist");
        boolean showTooltip = nbt.func_74767_n("show-tooltip");
        ListNBT inputList = nbt.func_150295_c("inputs", 10);
        ArrayList<ItemStorage> inputs = new ArrayList<ItemStorage>();
        for (INBT input : inputList) {
            if (!(input instanceof CompoundNBT)) continue;
            inputs.add((ItemStorage)controller.deserialize((CompoundNBT)input));
        }
        ItemStack primaryOutput = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result"));
        ListNBT secondaryList = nbt.func_150295_c("additional-output", 10);
        ArrayList<ItemStack> secondaryOutput = new ArrayList<ItemStack>();
        for (INBT secondary : secondaryList) {
            if (!(secondary instanceof CompoundNBT)) continue;
            secondaryOutput.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)secondary)));
        }
        ListNBT altList = nbt.func_150295_c("alternate-output", 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (INBT alt : altList) {
            if (!(alt instanceof CompoundNBT)) continue;
            secondaryOutput.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)alt)));
        }
        Block intermediate = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74781_a("intermediate").func_150285_a_()));
        return this.getNewInstance(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, CustomRecipe recipe, PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(recipe.getCrafter());
        packetBuffer.func_192572_a(recipe.getRecipeStorage().getRecipeSource());
        packetBuffer.writeBoolean(recipe.getRequiredResearchId() != null);
        if (recipe.getRequiredResearchId() != null) {
            packetBuffer.func_192572_a(recipe.getRequiredResearchId());
        }
        packetBuffer.writeBoolean(recipe.getExcludedResearchId() != null);
        if (recipe.getExcludedResearchId() != null) {
            packetBuffer.func_192572_a(recipe.getExcludedResearchId());
        }
        packetBuffer.writeBoolean(recipe.getLootTable() != null);
        if (recipe.getLootTable() != null) {
            packetBuffer.func_192572_a(recipe.getLootTable());
        }
        packetBuffer.func_150787_b(recipe.getMinBuildingLevel());
        packetBuffer.func_150787_b(recipe.getMaxBuildingLevel());
        packetBuffer.writeBoolean(recipe.getMustExist());
        packetBuffer.writeBoolean(recipe.getShowTooltip());
        packetBuffer.func_150787_b(recipe.getInputs().size());
        for (ItemStorage input : recipe.getInputs()) {
            controller.serialize(packetBuffer, input);
        }
        packetBuffer.func_150788_a(recipe.getPrimaryOutput());
        packetBuffer.func_150787_b(recipe.getSecondaryOutput().size());
        for (ItemStack secondary : recipe.getSecondaryOutput()) {
            packetBuffer.func_150788_a(secondary);
        }
        packetBuffer.func_150787_b(recipe.getAltOutputs().size());
        for (ItemStack alts : recipe.getAltOutputs()) {
            packetBuffer.func_150788_a(alts);
        }
        packetBuffer.func_192572_a(recipe.getIntermediate().getRegistryName());
    }

    @Override
    @NotNull
    public CustomRecipe deserialize(@NotNull IFactoryController controller, PacketBuffer buffer) throws Throwable {
        String crafter = buffer.func_218666_n();
        ResourceLocation recipeId = buffer.func_192575_l();
        ResourceLocation researchReq = buffer.readBoolean() ? buffer.func_192575_l() : null;
        ResourceLocation researchExclude = buffer.readBoolean() ? buffer.func_192575_l() : null;
        ResourceLocation lootTable = buffer.readBoolean() ? buffer.func_192575_l() : null;
        int minBldgLevel = buffer.func_150792_a();
        int maxBldgLevel = buffer.func_150792_a();
        boolean mustExist = buffer.readBoolean();
        boolean showTooltip = buffer.readBoolean();
        ArrayList<ItemStorage> inputs = new ArrayList<ItemStorage>();
        for (int numInputs = buffer.func_150792_a(); numInputs > 0; --numInputs) {
            inputs.add((ItemStorage)controller.deserialize(buffer));
        }
        ItemStack primaryOutput = buffer.func_150791_c();
        ArrayList<ItemStack> secondaryOutput = new ArrayList<ItemStack>();
        for (int numSec = buffer.func_150792_a(); numSec > 0; --numSec) {
            secondaryOutput.add(buffer.func_150791_c());
        }
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int numAlts = buffer.func_150792_a(); numAlts > 0; --numAlts) {
            altOutputs.add(buffer.func_150791_c());
        }
        Block intermediate = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        return this.getNewInstance(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.CUSTOM_RECIPE_ID;
    }
}

